multiJob('cb-dropship-build') {
  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/dropship', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  configure { project ->
    project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
  }

  publishers {
    githubCommitNotifier()
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    phase('Build') {
      phaseJob('cb-dropship-api-build') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-dropship-userdestroy-build') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

    }
  }
}

freeStyleJob('cb-dropship-api-build') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'cb/dropship', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_api.sh'
  }
}

freeStyleJob('cb-dropship-userdestroy-build') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'cb/dropship', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell 'PACKAGE_PATH=cmd/userdestroy/main.go ./scripts/build_lambda.sh'
  }
}

// DEPLOY
multiJob('cb-dropship-deploy') {
  parameters {
    stringParam 'BRANCH'
    stringParam 'ENVIRONMENT'
    stringParam 'GIT_COMMIT'
    stringParam 'HOSTS'
    stringParam 'SKADI_ID'
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    timestamps()
    buildName('#\${BUILD_NUMBER} (\${BRANCH}) - \${ENVIRONMENT}')
  }

  steps {
    phase('Deploy') {
      phaseJob('cb-dropship-deploy-api') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-dropship-deploy-userdestroy') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}

freeStyleJob('cb-dropship-deploy-api') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/dropship', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_api.sh'
  }
}

freeStyleJob('cb-dropship-deploy-userdestroy') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/dropship', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell 'PACKAGE_PATH=cmd/userdestroy/main.go ./scripts/build_lambda.sh'
    shell 'FUNCTION_NAME=cb-dropship-$ENVIRONMENT-userdestroy ./scripts/deploy_lambda.sh'
  }
}
