#!/bin/bash
set -e

rm -rf deploy
mkdir -p deploy

cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker-registry.internal.justin.tv/cb/dropship-api:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-dropship-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

echo "cb-dropship-$ENVIRONMENT-api-$GIT_COMMIT"

eb deploy cb-dropship-$ENVIRONMENT-api \
  --label $ENVIRONMENT-api-$GIT_COMMIT \
  --message "$BRANCH" \
  --timeout 25 \
  --verbose

echo "cb.dropship.$ENVIRONMENT.deploy:1|c" | nc -w 1 -u graphite.internal.justin.tv 8125
