variable "allow_assume_role_arn" {
  type        = string
  description = "AWS IAM Role ARN to allow to assume the application's role.  Used to allow jenkins to assume the development role."
}

variable "asg_max_size" {
  type        = string
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = string
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_account_id" {
  type        = string
  description = "AWS account id"
}

variable "aws_key_name" {
  type        = string
  description = "EC2 instance deploy key"
}

variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "dropship"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Creator Business email alias"
}

variable "private_subnets" {
  type        = string
  description = "Creator Business private subnets"
}

variable "project" {
  type        = string
  default     = "cb/dropship"
  description = "GitHub repository name"
}

variable "quick_actions_layout_table_arn" {
  type        = string
  description = "ARN of the quick actions layout dynamodb table"
}

variable "security_group" {
  type        = string
  description = "Creator Business security group"
}

variable "solution_stack_name" {
  type        = string
  default     = "64bit Amazon Linux 2018.03 v2.12.6 running Docker 18.06.1-ce"
  description = "Application stack specification"
}

variable "team" {
  type        = string
  default     = "Creator Business"
  description = "Twitch team name"
}

variable "vpc_id" {
  type        = string
  description = "Creator Business vpc"
}
