# Alarms when the health of the environment goes into degraded or severe
resource "aws_cloudwatch_metric_alarm" "app_beanstalk_environment_health" {
  alarm_name          = "${var.beanstalk_environment_name}-health"
  alarm_description   = "Monitors the health of ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "EnvironmentHealth"
  namespace           = "AWS/ElasticBeanstalk"
  period              = 60
  statistic           = "Maximum"
  threshold           = 20 # Degraded

  dimensions = {
    EnvironmentName = var.beanstalk_environment_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the average latency of the environment crosses 1s for 20 minutes
resource "aws_cloudwatch_metric_alarm" "app_beanstalk_avg_latency" {
  alarm_name          = "${var.beanstalk_environment_name}-avg-latency"
  alarm_description   = "Monitors the average latency of ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "Latency"
  namespace           = "AWS/ElasticBeanstalk"
  period              = 60
  statistic           = "Average"
  threshold           = 1000

  dimensions = {
    EnvironmentName = var.beanstalk_environment_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the average cpu utilization of the environment crosses 80% for 20 minutes
resource "aws_cloudwatch_metric_alarm" "app_beanstalk_environment_cpu" {
  alarm_name          = "${var.beanstalk_environment_name}-avg-cpu"
  alarm_description   = "Monitors the average cpu utilization of ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "CPUUtilization"
  namespace           = "AWS/ElasticBeanstalk"
  period              = 60
  statistic           = "Average"
  threshold           = 80

  dimensions = {
    EnvironmentName = var.beanstalk_environment_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the amount of 5XX backend errors reaches 500 for 5 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_backend_5XX" {
  alarm_name          = "${var.beanstalk_environment_name}-backend-5XX"
  alarm_description   = "Monitors the number of backend 5XX responses from ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 5
  metric_name         = "HTTPCode_Backend_5XX"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Sum"
  threshold           = 500

  dimensions = {
    LoadBalancerName = var.beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the amount of spillover from the surge queue reaches 2500 for 2 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_spillover" {
  alarm_name          = "${var.beanstalk_environment_name}-spillover"
  alarm_description   = "Monitors the number of requests spilled from the surge queue from ${var.name} Elastic Beanstalk load balancer"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Spillover"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Sum"
  threshold           = 2500

  dimensions = {
    LoadBalancerName = var.beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the amount of 5XX errors returned from the ELB reaches 500 for 5 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_5XX" {
  alarm_name          = "${var.beanstalk_environment_name}-elb-5xx"
  alarm_description   = "Monitors the number of 5XX responses from ${var.name} Elastic Beanstalk load balancer"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "HTTPCode_ELB_5XX"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Sum"
  threshold           = 500

  dimensions = {
    LoadBalancerName = var.beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the latency of the ELB to instances is greater than 500ms for 20 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_latency" {
  alarm_name          = "${var.beanstalk_environment_name}-elb-latency"
  alarm_description   = "Monitors the latency from ${var.name} Elastic Beanstalk load balancer"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "Latency"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Average"
  threshold           = 500

  dimensions = {
    LoadBalancerName = var.beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
