# Alarms when the write capacity of the dynamodb table exceeds the threshold for 5 minutes
resource "aws_cloudwatch_metric_alarm" "app_dynamodb_write_capacity" {
  alarm_name          = "${var.quick_action_layout_table_name}-write-capacity"
  alarm_description   = "Monitors the write capacity of ${var.name} quick action layout dynamodb table"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 5
  metric_name         = "ConsumedWriteCapacityUnits"
  namespace           = "AWS/DynamoDB"
  period              = 60
  statistic           = "Average"
  threshold           = 500

  dimensions = {
    TableName = var.quick_action_layout_table_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the read capacity of the dynamodb table exceeds the threshold for 5 minutes
resource "aws_cloudwatch_metric_alarm" "app_dynamodb_read_capacity" {
  alarm_name          = "${var.quick_action_layout_table_name}-read-capacity"
  alarm_description   = "Monitors the read capacity of ${var.name} quick action layout dynamodb table"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 5
  metric_name         = "ConsumedReadCapacityUnits"
  namespace           = "AWS/DynamoDB"
  period              = 60
  statistic           = "Average"
  threshold           = 500

  dimensions = {
    TableName = var.quick_action_layout_table_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
