variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "beanstalk_environment_name" {
  type        = string
  description = "Name of the beanstalk application"
}

variable "beanstalk_loadbalancer_name" {
  type        = string
  description = "Load balancer name for the beanstalk application"
}

variable "name" {
  type        = string
  default     = "dropship"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "quick_action_layout_table_name" {
  type        = string
  description = "Name of the quick action layout dynamoDB table"
}

variable "pagerduty_endpoint" {
  type        = string
  description = "PagerDuty endpoint to POST to when an alarm is triggered in EBS"
}
