data "aws_iam_role" "autoscale_iam_role" {
  name = "AWSServiceRoleForApplicationAutoScaling_DynamoDBTable"
}

resource "aws_appautoscaling_target" "quick_actions_layout_read_target" {
  max_capacity       = var.quick_actions_layout_read_capacity["max"]
  min_capacity       = var.quick_actions_layout_read_capacity["min"]
  resource_id        = "table/${aws_dynamodb_table.quick_actions_layout.name}"
  role_arn           = data.aws_iam_role.autoscale_iam_role.arn
  scalable_dimension = "dynamodb:table:ReadCapacityUnits"
  service_namespace  = "dynamodb"
}

resource "aws_appautoscaling_policy" "quick_actions_layout_read_policy" {
  name               = "DynamoDBReadCapacityUtilization:${aws_appautoscaling_target.quick_actions_layout_read_target.resource_id}"
  policy_type        = "TargetTrackingScaling"
  resource_id        = aws_appautoscaling_target.quick_actions_layout_read_target.resource_id
  scalable_dimension = aws_appautoscaling_target.quick_actions_layout_read_target.scalable_dimension
  service_namespace  = aws_appautoscaling_target.quick_actions_layout_read_target.service_namespace

  target_tracking_scaling_policy_configuration {
    predefined_metric_specification {
      predefined_metric_type = "DynamoDBReadCapacityUtilization"
    }

    target_value = 80
  }
}

resource "aws_appautoscaling_target" "quick_actions_layout_write_target" {
  max_capacity       = var.quick_actions_layout_write_capacity["max"]
  min_capacity       = var.quick_actions_layout_write_capacity["min"]
  resource_id        = "table/${aws_dynamodb_table.quick_actions_layout.name}"
  role_arn           = data.aws_iam_role.autoscale_iam_role.arn
  scalable_dimension = "dynamodb:table:WriteCapacityUnits"
  service_namespace  = "dynamodb"
}

resource "aws_appautoscaling_policy" "quick_actions_layout_write_policy" {
  name               = "DynamoDBReadCapacityUtilization:${aws_appautoscaling_target.quick_actions_layout_write_target.resource_id}"
  policy_type        = "TargetTrackingScaling"
  resource_id        = aws_appautoscaling_target.quick_actions_layout_write_target.resource_id
  scalable_dimension = aws_appautoscaling_target.quick_actions_layout_write_target.scalable_dimension
  service_namespace  = aws_appautoscaling_target.quick_actions_layout_write_target.service_namespace

  target_tracking_scaling_policy_configuration {
    predefined_metric_specification {
      predefined_metric_type = "DynamoDBWriteCapacityUtilization"
    }

    target_value = 80
  }
}
