resource "aws_dynamodb_table" "quick_actions_layout" {
  name           = "${var.name}-${var.environment}-quick-actions-layout"
  read_capacity  = var.quick_actions_layout_read_capacity["default"]
  write_capacity = var.quick_actions_layout_write_capacity["default"]
  hash_key       = "owner_id"
  range_key      = "channel_id"

  attribute {
    name = "owner_id"
    type = "S"
  }
  attribute {
    name = "channel_id"
    type = "S"
  }

  point_in_time_recovery {
    enabled = true
  }

  lifecycle {
    ignore_changes = [
      read_capacity,
      write_capacity,
    ]
  }

  tags = {
    DDBTableGroupKey-Dropship = "Dropship"
  }
}
