variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "dropship"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "quick_actions_layout_read_capacity" {
  type        = map(string)
  description = "Read capacity map for the table"
}

variable "quick_actions_layout_write_capacity" {
  type        = map(string)
  description = "Write capacity map for the table"
}

variable "channel_quick_action_index_read_capacity" {
  description = "Read capacity for the ChannelQuickActionIndex gsi"
}

variable "channel_quick_action_index_write_capacity" {
  description = "Write capacity for the ChannelQuickActionIndex gsi"
}
