data "aws_iam_policy_document" "assume_lambda_role" {
  statement {
    effect  = "Allow"
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["lambda.amazonaws.com"]
    }
  }
}

# This refers to the nested cloudformation stack under the cb-eventbus root stack, where the outputs are defined.
data "aws_cloudformation_stack" "eventbus" {
  name = "cb-eventbus-EventBus-NOVC3F3JLAX3"
}

resource "aws_iam_role" "eventbus_lambda_role" {
  name               = "cb-${var.name}-${var.environment}-eventbus-lambda-role"
  assume_role_policy = data.aws_iam_policy_document.assume_lambda_role.json
}

resource "aws_iam_role_policy_attachment" "eventbus_access_attach" {
  role       = aws_iam_role.eventbus_lambda_role.name
  policy_arn = data.aws_cloudformation_stack.eventbus.outputs["EventBusAccessPolicyARN"]
}

resource "aws_iam_role_policy_attachment" "userdestroy_vpc_access_execution_role" {
  role       = aws_iam_role.eventbus_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole"
}

resource "aws_iam_role_policy_attachment" "userdestroy_sqs_queue_execution_role" {
  role       = aws_iam_role.eventbus_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaSQSQueueExecutionRole"
}

