// Zips up Lambda function folder
data "archive_file" "eventbus_lambda_zip" {
  type        = "zip"
  source_dir  = var.lambda_directory
  output_path = "${var.lambda_directory}/${var.lambda_zip_filename}"
}

resource "aws_lambda_function" "eventbus_lambda" {
  filename         = "${var.lambda_directory}/${var.lambda_zip_filename}"
  function_name    = "${var.team_code}-${var.name}-${var.environment}-userdestroy"
  role             = aws_iam_role.eventbus_lambda_role.arn
  handler          = "main"
  source_code_hash = data.archive_file.eventbus_lambda_zip.output_base64sha256
  runtime          = "go1.x"
  description      = "Removes quick action layout data when a user is destroyed"
  timeout          = 60

  environment {
    variables = {
      ENVIRONMENT       = var.environment
      LAYOUT_TABLE_NAME = var.layout_table_name
      STATS_HOST        = var.stats_host
      REGION            = var.aws_region
    }
  }

  vpc_config {
    subnet_ids         = split(",", var.private_subnets)
    security_group_ids = var.security_group
  }

  tags = {
    Name    = var.name
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }
}

resource "aws_lambda_event_source_mapping" "sqs" {
  batch_size       = 1
  event_source_arn = var.userdestroy_sqs_arn
  function_name    = aws_lambda_function.eventbus_lambda.function_name
}

resource "aws_lambda_permission" "sqs" {
  statement_id  = "allow_sqs_to_invoke"
  action        = "lambda:InvokeFunction"
  function_name = aws_lambda_function.eventbus_lambda.function_name
  principal     = "sqs.amazonaws.com"
  source_arn    = var.userdestroy_sqs_arn
}

