variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "dropship"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Owner contact email"
}

variable "project" {
  type        = string
  default     = "cb/dropship"
  description = "GitHub repository name"
}

variable "team" {
  type    = string
  default = "Creator Business"
}

variable "team_code" {
  type    = string
  default = "cb"
}

variable "lambda_zip_filename" {
  type    = string
  default = "eventbus_userdestroy.zip"
}

variable "lambda_directory" {
  type    = string
  default = "../../build/lambda/userdestroy"
}

variable "layout_table_name" {
  type = string
}

variable "stats_host" {
  type = string
}

variable "userdestroy_sqs_arn" {
  type = string
}

variable "private_subnets" {
  type        = string
  description = "The subnets in the VPC that Twitch infrastructure should be created in."
}

variable "security_group" {
  type        = list(string)
  description = "The security groups of the subnets in the VPC that Twitch infrastructure should be created in."
}
