# This refers to the nested cloudformation stack under the cb-eventbus root stack, where the outputs are defined.
data "aws_cloudformation_stack" "eventbus" {
  name = "cb-eventbus-EventBus-NOVC3F3JLAX3"
}

resource "aws_sqs_queue" "eventbus-userdestroy" {
  name                       = "eventbus-cb-${var.name}-${var.environment}-userdestroy"
  visibility_timeout_seconds = 60
  message_retention_seconds  = 604800 # 7 days
  policy                     = data.aws_cloudformation_stack.eventbus.outputs["EventBusSQSPolicyDocument"]
  kms_master_key_id          = data.aws_cloudformation_stack.eventbus.outputs["EventBusKMSMasterKeyARN"]
  redrive_policy             = "{\"deadLetterTargetArn\":\"${aws_sqs_queue.eventbus-userdestroy-dlq.arn}\",\"maxReceiveCount\":5}"
}

resource "aws_sqs_queue" "eventbus-userdestroy-dlq" {
  name                      = "eventbus-cb-${var.name}-${var.environment}-userdestroy-deadletter"
  message_retention_seconds = 604800 # 7 days
  kms_master_key_id         = data.aws_cloudformation_stack.eventbus.outputs["EventBusKMSMasterKeyARN"]
}
