terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "cb-dropship-terraform-production"
    key     = "production/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

module "beanstalk" {
  source      = "../modules/beanstalk"
  environment = "production"

  allow_assume_role_arn = "arn:aws:iam::989470033077:user/devtools-jenkins"
  aws_account_id        = "989470033077"
  aws_key_name          = "cb-dropship-production"
  aws_profile           = "twitch-cb-aws"
  aws_region            = "us-west-2"

  asg_max_size = 4
  asg_min_size = 2

  private_subnets = "subnet-45e7ad0c,subnet-6f4a7808,subnet-86fe23dd"
  security_group  = "sg-57251d2c"
  vpc_id          = "vpc-7851b71e"

  quick_actions_layout_table_arn = module.dynamodb.quick_actions_layout_table_arn
}

module "dynamodb" {
  source      = "../modules/dynamodb"
  environment = "production"

  aws_profile = "twitch-cb-aws"
  aws_region  = "us-west-2"

  channel_quick_action_index_read_capacity  = 100
  channel_quick_action_index_write_capacity = 25

  quick_actions_layout_read_capacity = {
    "default" = 250
    "min"     = 100
    "max"     = 750
  }

  quick_actions_layout_write_capacity = {
    "default" = 100
    "min"     = 25
    "max"     = 500
  }
}

module "cloudwatch" {
  source = "../modules/cloudwatch"

  aws_profile = "twitch-cb-aws"
  aws_region  = "us-west-2"

  beanstalk_environment_name     = "cb-dropship-production-api"
  beanstalk_loadbalancer_name    = "awseb-e-r-AWSEBLoa-BQOA9VBNNA4P"
  quick_action_layout_table_name = "dropship-production-quick-actions-layout"

  pagerduty_endpoint = "https://events.pagerduty.com/integration/841cac770e3c431b875f72aedc8dc17b/enqueue"
}

module "sqs" {
  source      = "../modules/sqs"
  environment = "production"
  aws_profile = "twitch-cb-aws"
  aws_region  = "us-west-2"
}

module "lambda" {
  source            = "../modules/lambda"
  environment       = "production"
  layout_table_name = "dropship-production-quick-actions-layout"
  stats_host        = "statsd.central.twitch.a2z.com:8125"

  private_subnets = "subnet-45e7ad0c,subnet-6f4a7808,subnet-86fe23dd"
  security_group  = ["sg-57251d2c"]

  userdestroy_sqs_arn = module.sqs.userdestroy_arn
}
