# Hallpass

[![Build Status](https://jenkins-og.xarth.tv/buildStatus/icon?job=cb-hallpass-build)](https://jenkins-og.xarth.tv/job/cb-hallpass-build)

🐱 🍔 Permission Service - Ask nicely and you shall receive

Hallpass manages channel permissions. Currently, this is only channel editors. You can list, create, delete, and check editors for a channel here.

## Service Resources
| Resource            |
|---------------------|
| [Runbook](./docs/runbook.md) |
| [Dashboard](https://grafana.xarth.tv/d/000001491/hallpass)       | 
| [Slack](https://twitch.slack.com/archives/C2VA4EXN0)           |
| [Pagerduty](https://twitchoncall.pagerduty.com/services/PEB0RVF)       |
| [Service Catalog](https://catalog.xarth.tv/services/296) |
| [Jarvis](https://jarvis.xarth.tv/availability/service/2020/m03?service_id=296)
| [SLA](/docs/service_level_agreement.md) | 
| [Jenkins Build](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-hallpass-build/) |
| [Jenkins Deploy](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-hallpass-deploy/) |
| [Rollbar Logs](https://rollbar.com/Twitch/CB_Hallpass/items) |
| [API Docs](./docs/api.md) |

Consult the [docs](./docs) for more details, including design and architecture choices.

## Table of Contents
1. [Service Links](#service-links)
2. [Using Hallpass](#using-hallpass)
3. [Development](#development)
    1. [Installation](#installation)
    2. [Running](#running)
    3. [Dependencies](#dependencies)
    4. [Testing](#testing)
    5. [Worker Environment](#worker-environment)

## Service Links
| Environment | AWS Account | DNS Name | VPC Endpoint Service |
|-------------|-------------|----------|----------------------|
| staging     | [twitch-cb-aws](https://twitch-cb-aws.signin.aws.amazon.com/console) | http://staging.hallpass.cb.twitch.a2z.com | `com.amazonaws.vpce.us-west-2.vpce-svc-05c9a9682cec9fa80`
| production  | [twitch-cb-aws](https://twitch-cb-aws.signin.aws.amazon.com/console) | http://prod.hallpass.cb.twitch.a2z.com | `com.amazonaws.vpce.us-west-2.vpce-svc-051cf257eb25dd6d5`

Ask in #dashboard-feedback to get your AWS account allowlisted for privatelinking.

If you would like to speed up this process, we can grant you write access to create a small PR with the necessary changes to [staging](https://git.xarth.tv/cb/hallpass/blob/master/terraform/staging/main.tf#L28) and [prod](https://git.xarth.tv/cb/hallpass/blob/master/terraform/production/main.tf#L28). Simply create an entry for your service in each of the two `vpc_endpoint_service_allowed_principals` lists and submit the PR, and we should be able to help you deploy this change more quickly.

For example, if your staging account id is 12345 and your prod account id is 54321, add

`"arn:aws:iam::12345:root", # twitch-your-service` 

to the [staging](https://git.xarth.tv/cb/hallpass/blob/master/terraform/staging/main.tf#L28) list and

`"arn:aws:iam::54321:root", # twitch-your-service` 

to the [prod](https://git.xarth.tv/cb/hallpass/blob/master/terraform/production/main.tf#L28) list.

## Using Hallpass

Before using Hallpass, make sure to properly setup the [Service Links](#service-links) as described in the section above.

First, add Hallpass as a dependency in your service using your preferred dependency manager. From there, create a client:

```go
client, err := hallpass.NewClient(twitchhttp.ClientConf{
    Host: "hallpass-staging-or-prod-host",
    // any other twitch client configuration you want
})
```

Then, you can use the client to perform operations on a channels editors. The operations available to the client can be found [here](https://git.xarth.tv/cb/hallpass/blob/master/client/hallpass/client.go#L11).

## Development

### Installation

Run `make setup` to create a local, empty copy of the Hallpass DB.

Hallpass uses Redis to cache request results. If you wish, you can create and start a local Redis cache. If you've never used Redis before, maybe start [here](https://redis.io/documentation). Starting a local Redis server is not required, and is really only necessary if you want to test out caching locally. It's recommended to test caching on staging.

### Running

After installing, ensure that postgres is running. If you've installed postgres with Homebrew, you can run the following:

`pg_ctl -D /usr/local/var/postgres start`

Run `make dev-api` at the project root to start the hallpass api locally.

Running `make dev-worker` will start the Hallpass worker environment. The worker exists solely to read messages published to the `hard_delete_user` SNS topic, and delete the editors for the removed user. You can see more info on the SNS topic [here](https://git.xarth.tv/web/users-service/blob/master/doc/publishedEvents.md#events-published-to-sns).

Hallpass uses some default environment variables to configure things locally, which are as follows:

```sh
ENVIRONMENT ?= "dev"
REDIS_HOST ?= 127.0.0.1:6379
USERS_SERVICE_HOST ?= https://dev.users-service.twitch.a2z.com
STATSD_HOST ?= "statsd.central.twitch.a2z.com:8125"
DB_HOST ?= localhost
DB_PORT ?= 5432
DB_NAME ?= hallpass
DB_SSLMODE ?= disable
```

If you want to change this configuration, you can do so in the [makefile](./Makefile).

### Dependencies

Dependency management is done using dep. Add your dependency to the `Gopkg.toml` file, and then run `make update` to install it.

### Testing

Mockery is used to generate testing mocks. You can run `make mocks` to generate mocks for packages in the `internal` directory. If for some reason you need to generate mocks for anything outside of that directory, can add change the `make mocks` command and add something like the following:

`mockery -all -dir=$INPUTDIR -case=underscore -output=$OUTPUTDIR`

Running `make test` will run unit tests for the entire project.

### Deployment

Deployment is done through clean-deploy. See the docs on [deployment](./docs/deployment.md) for details.

### Worker Environment

Hallpass also has a worker environment that's capable of listening and responding to SNS messages. If you have a project that affects a channel's editors, publishing messages to an SNS topic that Hallpass can subscribe to is a good way to handle that behaviour. For assistance, ask in #dashboard-feedback.
