# Alarms
Cloudwatch alarms exist [here](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarmsV2:?~(search~'cb-hallpass~alarmStateFilter~'ALL~alarmTypeFilter~'ALL~currentPageIndex~'1)) for monitoring Hallpass infrastructure.

Cloudwatch alarms are integrated with PagerDuty, and will send an alert when the alarm state enters `ALARM`. PagerDuty alerts will be automatically resolved if the alarm returnes to the `OK` state.

All alarms are configured through [terraform](https://git.xarth.tv/cb/hallpass/tree/master/terraform/modules/pagerduty).

## Table of Contents
1. [cb-hallpass-production-cache-conns](#cb-hallpass-production-cache-conns)
2. [cb-hallpass-production-api-application-health](#cb-hallpass-production-api-application-health)
3. [cb-hallpass-production-api-asg-avg-cpu](#cb-hallpass-production-api-asg-avg-cpu)
4. [cb-hallpass-production-api-latency](#cb-hallpass-production-api-latency)
5. [cb-hallpass-production-cache-engine-cpu](#cb-hallpass-production-cache-engine-cpu)
6. [cb-hallpass-production-cache-cpu](#cb-hallpass-production-cache-cpu)
7. [cb-hallpass-production-db-conns](#cb-hallpass-production-db-conns)
8. [cb-hallpass-production-db-free-space](#cb-hallpass-production-db-free-space)
9. [cb-hallpass-production-api-avg-latency](#cb-hallpass-production-api-avg-latency)
10. [cb-hallpass-production-db-cpu](#cb-hallpass-production-db-cpu)
11. [cb-hallpass-production-cache-freeable-mem](#cb-hallpass-production-cache-freeable-mem)
12. [cb-hallpass-production-cache-bytes_used](#cb-hallpass-production-cache-bytes_used)

## cb-hallpass-production-cache-conns
The number of connections to the redis cache is too high or spiking. 

This could be caused by request spikes or improper connections to the cache from instances. Check the Elastic Beanstalk health and the current request load. Instances can be killed off to spare the cache if necessary.

## cb-hallpass-production-api-application-health
`Alert: Maximum EnvironmentHealth GreaterThanOrEqualToThreshold 20.0`
This alarm indicates the hallpass api is in a severe state. The quickest way to diagnose a problem is to check the beanstalk [health](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/health?applicationName=cb-hallpass-production&environmentId=e-efmuvaybun) page. Look for any unhealthy instances and any related messaging. Unhealthy instances can be terminated manually, and new instances will be spun up by the auto scaler.

If the health page does not contain enough information, logs can be downloaded from the hallpass instances [here](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/logs?applicationName=cb-hallpass-production&environmentId=e-efmuvaybun).

## cb-hallpass-production-api-asg-avg-cpu
CPU Utilization in the Elastic Beanstalk app is too high. 

Instances are either overloaded with requests or failing. More instances can be added to distribute load, or instances should be increased in size to get bigger vCPUs.

## cb-hallpass-production-api-latency
Latency from Hallpass API instances is too high.

Instances may be overloaded due to request load, which should be inspected. More instances can be added to the environment temporarily to handle higher load.

## cb-hallpass-production-cache-engine-cpu
Redis is reporting high CPU utilization from the engine.

Connections or load on the cache may be too high. Decreasing conns and putting more load on the DB might help the cache stabilize.

## cb-hallpass-production-cache-cpu
Redis is reporting high CPU utilization.

Connections or load on the cache may be too high. Decreasing conns and putting more load on the DB might help the cache stabilize.

## cb-hallpass-production-db-conns
The RDS instance is reporting too many connections.

Check the instance count and ensure ther aren't too many making conns to the db. There is a parameter in the code to limit db conns [here](https://git.xarth.tv/cb/hallpass/blob/master/internal/db/client.go#L9). This can be lowered if necessary.

## cb-hallpass-production-db-free-space
The RDS instance is running out of storage space.

Resize the instance from the RDS console.

## cb-hallpass-production-api-avg-latency
Average P90 latency is too high from the Hallpass API instances.

Instances may be overloaded due to request load, which should be inspected. More instances can be added to the environment temporarily to handle higher load.

## cb-hallpass-production-db-cpu
The RDS instance is reporting high CPU utilization.

Consider increasing the size of the instance, or attempting to lower the load on the db by eliminating connections.

## cb-hallpass-production-cache-freeable-mem
The redis cache is running out of freeable memory and may not be able to write or read properly.

Consider elimination existing connections to reduce load on the cache.

## cb-hallpass-production-cache-bytes_used
The redis cache is running out of space.

The cache needs to be resized, or data removed to lower the amount of space used.



