# Hallpass API

## Table of Contents
1. [GET editors v1](#get-editors-v1)
2. [GET editors v2](#get-editors-v2)
2. [GET editable channels](#get-editable-channels)
3. [GET is editor](#get-is-editor)
4. [POST create editor](#post-create-editor)
5. [DELETE remove editor](#delete-remove-editor)

## GET editors v1
`GET v1/permissions/channels/:channel_id/editors`

Retrieves a list of editors for a given channel_id ("users that can edit my channel").

### Params
| Name | Location | Type |
|------|----------|------|
| channel_id | Path | String |

### Response
```
{
    "editors": [
        "000000",
        "111111",
        ...
    ]
}
```

## GET editors v2
`GET v2/channels/:channel_id/editors`

Retrieves a list of editors for a given channel_id ("users that can edit my channel"). This route includes timestamps indicating when the editor was created. If you do not need timestamps, you should use the v1 endpoint.

### Params
| Name | Location | Type |
|------|----------|------|
| channel_id | Path | String |

### Response
```
{
    "editors": [
        {
            "editor_user_id": "000000",
            "created_on": "2019-01-01 0000.00.00"
        },
        {
            "editor_user_id": "111111",
            "created_on": "2019-01-01 0000.00.00"
        }
        ...
    ]
}
```

## GET editable channels
`GET v1/permissions/channels/:channel_id/editable_channels`

Retrieves a list of channels that are editable by the given channel_id ("channels I am an editor for").

### Params
| Name | Location | Type |
|------|----------|------|
| channel_id | Path | String |

### Response
```
{
    "editable": [
        "000000",
        "111111",
        ...
    ]
}
```

## GET is editor
`GET v1/permissions/channels/:channel_id/editors/:editor_id`

Checks if a given `editor_id` is an editor for the given `channel_id`. Returns true if they are, and false otherwise.

### Params
| Name | Location | Type |
|------|----------|------|
| channel_id | Path | String |
| editor_id | Path | String |

### Response
```
{
    "is_editor": <bool>
}
```

## POST create editor
`POST v1/permissions/channels/:channel_id/editors`

Creates a new editor for the given channel_id.  A request body is required, and it should contain the id's of the channel granting the permission, as well as the channel the editor permissions is for.

### Params
| Name | Location | Type |
|------|----------|------|
| channel_id | Path | String |
| granted_by | Body | String |
| granted_to | Body | String |

### Request Body
```
{
    "granted_by": "000000", // the channel granting the permission
    "granted_to": "111111" // the channel receiving editor permissions
}
```

### Response
```
{
    "granted_to": "<channel_id>"
}
```

## DELETE remove editor
`DELETE v1/permissions/channels/:channel_id/editors/:editor_id`

Remove an editor with the given `<editor_id>`, for the given `<channel_id>`. If the editor doesn't exist for that channel, this does nothing but still returns success.

### Params
| Name | Location | Type |
|------|----------|------|
| channel_id | Path | String |
| editor_id | Path | String |

### Response
```
{
    "status": "<string>"
}
```
