## Deploying Hallpass
Deployment is done using [clean-deploy](https://deploy.xarth.tv/#/cb/hallpass).

1. Create a new branch for a feature in [cb/hallpass](https://git.xarth.tv/cb/hallpass).
2. After writing your feature, you can test locally by running `make dev` and making calls to `localhost`.
3. Using clean-deploy, deploy your branch to the Hallpass Staging environment and test it. Errors can be found logged to [Rollbar](https://rollbar.com/Twitch/CB_Hallpass/items/), or, if you prefer, in the slack channel #cplat-backend-deploys.
4. Create a pull request for your branch. You can ask in the slack channels #dashboard-feedback or #creator-business for a review.
5. After your PR is approved, merge your branch and deploy master to production using clean-deploy. You can test from the permissions dashboard on twitch (`https://dashboard.twitch.tv/u/:channel_login/community/roles`), or by calling Hallpass directly. Production errors are still logged in [Rollbar](https://rollbar.com/Twitch/CB_Hallpass/items/).
6. Verify that the Elastic Beanstalk application is healthy by visiting the [dashboard](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-hallpass-production&environmentId=e-efmuvaybun).

## Rollbacks
The fastest way to rollback a change is to use clean-deploy. Click the arrow next to the master branch, and select a previous version of the application. Deploy that version to production to rollback a change.
Make sure to make a new pull request to either fix your error, or revert the change. During this time, it's probably a good idea to freeze Hallpass from any deployments to make sure your broken change is not re-deployed. You can freeze the project from clean-deploy by clicking the `freeze hallpass` button in the top right corner.
