# Hallpass Design and Internals

Hallpass provides a basic CRUD API for performing channel editor management. It also uses a Lambda to handle EventBus messages for user deletion and ban events. Because Hallpass is a relatively high traffic service, it makes heavy use of caching and redis to achieve lower latencies.

## Redis
Caching in redis is done using a [set](https://redis.io/topics/data-types#sets) data structure. Each relevant operation corresponds to a redis set operation,
like adding and removing. The operations are implemented [here](https://git.xarth.tv/cb/hallpass/blob/master/internal/cache/permissions.go).

Because Hallpass returns info for editors of a channel and channels a user can edit, the cache contains two sets for a channel: `editors` and `editable`.

## Postgres
Behind redis, there is a postgres database with the following schema:

```sql
CREATE TABLE IF NOT EXISTS editors(
    id serial PRIMARY KEY,
    channel_id integer NOT NULL,
    editor_user_id integer NOT NULL,
    created_on timestamp DEFAULT current_timestamp NOT NULL,
    updated_on timestamp,
    UNIQUE (channel_id, editor_user_id)
);
```

Updates or additions to the schema can be done through migrations, which can be added or reviewed in the [db](https://git.xarth.tv/cb/hallpass/tree/master/db) package.
Migrations are performed using [goose](https://github.com/pressly/goose), however this is not a strict requirement for db migrations.

Database operations on the db can be found in the `internal/db` package [here](https://git.xarth.tv/cb/hallpass/tree/master/internal/db).

## Architecture

![Hallpass Architecture](./Hallpass_Architecture.png)

## Project Organization
`cmd`: entry points for the API and worker

`db`: contains schema and migrations for postgres

`client`: the API client

`scripts`: build and deploy scripts

`view`: request/response structs for the the API and worker.

`internal/api`: API logic

`internal/cache`: logic for working with redis

`internal/db`: logic for working with the postgres instance

`internal/eventbus`: eventbus handlers and data types
