# Disaster Recovery

## Database Recovery in us-west-2

In the event that the database needs to be **recovered** from a historic snapshot or restore point in us-west-2, the following steps can be taken to restore it. 

> Snapshots are created **once a day** at between 2-4am UTC, and restore points are created every **5 minutes**. Both are kept for **1 day**. [See also](https://aws.amazon.com/rds/faqs/#Automatic_Backups_and_Database_Snapshots)

- [ ] Navigate to the twitch-cb-aws [RDS AWS console](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#databases:)
- [ ] Follow instructions below, starting from **step#2** to restore the database.
  - From a [snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RestoreFromSnapshot.html)
  - From a [restore point](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html)
- [ ] Configure your new database with the following fields, the rest can be left as is:
  - [ ] `Multi-AZ Deployment: Yes`
- [ ] Run the the following commands from `hallpass` root to update remote S3 Terraform state:

  ```bash
  > cd terraform/staging
  > terraform init
  > terraform refresh
  > terraform state pull
  > terraform state show module.app.aws_db_instance.master # Should display current state
  > terraform state rm module.app.aws_db_instance.master
  ```
- [ ] Update the file `terraform/modules/hallpass/rds.tf`. For example, if your new database has the name `cb-hallpass-2-staging`, you should use the value `cb-hallpass-2-staging` as the database identifier:

  ```diff
  resource "aws_db_instance" "master" {
    ...

  -  identifier = "${var.team_code}-${var.name}-${var.environment}"
  +  identifier = "${var.team_code}-${var.name}-2-${var.environment}"

    ...
  }
  ```
- [ ] Update your new database to match configurations in Terraform:

  ```bash
  > terraform import module.app.aws_db_instance.master cb-hallpass-2-staging
  > terraform plan
  > terraform apply # Should only have update in-place changes
  ```
- [ ] Wait for `terraform apply` to finish, and verify that your new database status is `Available` on AWS console
- [ ] Navigate to your new database on the AWS console, and select `Modify`:
  - [ ] Change `New master password` to be the same as the original instance. Ask in the Slack channel #dashboard-feedback if you don't have access to the password
  - [ ] Select `Continue`, `Apply immediately`, and `Modify DB Instance`
  - [ ] From your database instance page on the AWS console, select `Reboot` from the top-right menu dropdown 
  - [ ] Wait for your new database status to change to `Available` on AWS console
- [ ] Copy your new database instance's **`Endpoint`**
- [ ] Navigate to twitch-cb-aws [Elastic Beanstalk console](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#) to update the database endpoint for the corresponding Elastic Beanstalk apps:
  - [`staging-api`](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/configuration?applicationName=cb-hallpass-staging&environmentId=e-uxzdhzdnwp) and [`staging-worker`](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-hallpass-staging&environmentId=e-vrj3m2xfas)
  - [`production-api`](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/configuration?applicationName=cb-hallpass-production&environmentId=e-efmuvaybun) and [`production-worker`](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-hallpass-production&environmentId=e-fqb4ztezn2)
- [ ] Navigate to [Clean-Deploy](https://deploy.xarth.tv/#/cb/hallpass) to deploy Hallpass master to the corresponding environment
- [ ] Wait for the deploy to complete
- [ ] Monitor [the Hallpass Grafana dashboard](https://grafana.xarth.tv/d/000001491/hallpass?orgId=1&refresh=30s)
- [ ] Manually test the ability to test editors by calling the API endpoints and by modifying on the Twitch site

## Database Recovery in us-east-2

If us-west-2 has a disaster, the database needs to be **recovered** from a historic snapshot or restore point in us-east-2. The following steps can be taken to restore it. 

> Snapshots are created **every 4 hours**, and restore points are created every **5 minutes**. Both are kept for **15 days**. [See also](https://aws.amazon.com/rds/faqs/#Automatic_Backups_and_Database_Snapshots)

- [ ] Navigate to the twitch-cb-aws us-east-2 [RDS AWS console](https://us-east-2.console.aws.amazon.com/rds/home?region=us-east-2#databases:)
- [ ] Follow instructions below to restore the database.
  - From a [snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RestoreFromSnapshot.html)
- [ ] Configure your new database with the following fields, the rest can be left as is:
  - [ ] `Multi-AZ Deployment: Yes`
- [ ] Navigate to your new database on the AWS console, and select `Modify`:
  - [ ] Change `New master password` to be the same as the original instance. Ask in the Slack channel #dashboard-feedback if you don't have access to the password
  - [ ] Select `Continue`, `Apply immediately`, and `Modify DB Instance`
  - [ ] From your database instance page on the AWS console, select `Reboot` from the top-right menu dropdown 
  - [ ] Wait for your new database status to change to `Available` on AWS console

We currently do not have a full recovery plan if us-west-2 goes down, but it is part of the initiative with [DR 2020](https://wiki.twitch.com/display/CTI/DR+2020). Contact the DR 2020 team on Slack #dr-2020 for further instructions.
