# Private Links
Hallpass supports private links for services that need to call the API internally. Links can be requested in #dashboard-feedback. The following links provide background information on how private linking works and what it's value is.

[Alex's Privatelink starter pack](https://git.xarth.tv/achou/privatelink/)

[AWS Static IP for Load Balancing blog post](https://aws.amazon.com/blogs/networking-and-content-delivery/using-static-ip-addresses-for-application-load-balancers/)

[Amazon wiki: Private Links for Dummies](https://w.amazon.com/bin/view/VPC/SPSforDummies)

[Fulton Privatelink docs](https://docs.fulton.twitch.a2z.com/docs/connecting_services.html#privatelink)

## Infrastructure
All required infra for private links is handled in the [terraform](https://git.xarth.tv/cb/hallpass/blob/master/terraform/modules/hallpass/privatelink.tf). It follows the standard architecture recommended from AWS in the blog post inked above.

## Allowlisting
When other services want to call Hallpass through privatelink, their aws accounts need to be allowlisted to access our VPC. This is managed through terraform, with different allowlists for [staging](https://git.xarth.tv/cb/hallpass/blob/master/terraform/staging/main.tf#L28) and [prod](https://git.xarth.tv/cb/hallpass/blob/master/terraform/production/main.tf#L28).

To allowlist an account, the following steps are required:
1. Get the account numbers and names for staging/dev and prod from the requester.
2. It might be helpful to get an estimate of potential rps as well, to ensure that large consumers can be handlded properly by Hallpass.
3. Add the account numbers, with the names in a comment, to the [staging](https://git.xarth.tv/cb/hallpass/blob/master/terraform/staging/main.tf#L28) and [prod](https://git.xarth.tv/cb/hallpass/blob/master/terraform/production/main.tf#L28) allowlists.
4. Open a pr with the changes
5. Use terrafrom to apply the change and merge the pr
6. Communicate to the requester that the accountd have been allowlisted, and they can perform steps to create required infra in their accounts to connect to Hallpass.
