## Hallpass Runbook
This describes the different components of Hallpass and how to operate them.

[twitch-cb-aws account](https://twitch-cb-aws.signin.aws.amazon.com/console) |
[Pagerduty](https://twitchoncall.pagerduty.com/services/PEB0RVF) |
[SLA](/docs/service_level_agreement.md) |
[clean-deploy](https://deploy.xarth.tv/#/cb/hallpass)

### Deploying and Rollbacks
See the deployment [docs](https://git.xarth.tv/cb/hallpass/tree/master/docs/deployment.md) for help with deploying and rolling back.

### Monitoring and Errors
Errors are logged to [rollbar](https://rollbar.com/Twitch/CB_Hallpass/items/).
There is a Grafana dashboard [here](https://grafana.xarth.tv/d/000001491/hallpass).
Beanstalk apps can also be monitored from the AWS console
1. [API](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/monitoring?applicationName=cb-hallpass-production&environmentId=e-efmuvaybun)
2. [Worker](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/monitoring?applicationName=cb-hallpass-production&environmentId=e-fqb4ztezn2)

### Pagerduty
[Pagerduty](https://twitchoncall.pagerduty.com/services/PEB0RVF)
Pagerduty is integrated with both Cloudwatch and rollbar. Pages are sent based on error rates and application health.

### Terraform
Infrastructure configuration is done using terraform. All these files live in the [git repo](https://git.xarth.tv/cb/hallpass/tree/master/terraform). Changes should be applied to both staging and production, and committed to the repo using a pull request.

### Elastic Beanstalk
Hallpass exists as an elastic beanstalk application, for both staging and production environments.
1. [production api](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-hallpass-production&environmentId=e-efmuvaybun)
2. [staging api](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-hallpass-staging&environmentId=e-uxzdhzdnwp)

The Hallpass beanstalk application also contains a worker tier environment, which is used to listen to SNS messages and process them. This is useful for reacting to other events on the site that require changes to a channel's editors.
1. [production worker](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-hallpass-production&environmentId=e-fqb4ztezn2)
2. [staging worker](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-hallpass-staging&environmentId=e-vrj3m2xfas)

### RDS
Hallpass is backed by a simple postgres database, with a single replica instance.
1. [production](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-hallpass-production) and [production replica](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-hallpass-production-replica).
2. [staging](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-hallpass-staging) and [staging replica](https://us-west-2.console.aws.amazon.com/rds/home?region=us-west-2#dbinstance:id=cb-hallpass-staging-replica).

Configuration for these databases can be found in the terraform files mentioned in the previous section.

### Elasticache
Hallpass makes heavy use of caching, particularly for calls to get editors and checking if a user is an editor of a channel. It uses redis in Elasticache.
1. [production cache](https://us-west-2.console.aws.amazon.com/elasticache/home?region=us-west-2#redis-nodes:id=cb-perm-prd;clusters=cb-perm-prd)
2. [staging cache](https://us-west-2.console.aws.amazon.com/elasticache/home?region=us-west-2#redis-nodes:id=cb-perm-stg;clusters=cb-perm-stg)

### Cloudwatch
Infrastructure health is monitored through Cloudwatch.
1. [Hallpass Alarms](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#alarmsV2:?~(search~'cb-hallpass~alarmStateFilter~'ALL~alarmTypeFilter~'ALL~currentPageIndex~'1))

### Past Alarms
See the [alarms docs](./alarms.md) for details.
