package api

import (
	"net/http"

	"code.justin.tv/cb/hallpass/internal/httputil"
	"code.justin.tv/cb/hallpass/view"
	log "github.com/sirupsen/logrus"
	"goji.io/pat"
)

func (s *Server) getV1Editors(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	channelID := pat.Param(req, "channel_id")

	// Check cache for existing channelID
	cachedEditors, err := s.redisClient.GetCachedEditors(channelID)

	if err != nil {
		log.WithError(err).Warn("failed to call editors cache")
	}

	if len(cachedEditors) > 0 {
		response := view.V1GetEditorsResponse{
			Editors: cachedEditors,
		}

		jsonWriter.OK(response)
		return
	}

	editors, err := s.dbReader.GetEditors(req.Context(), channelID)
	if err != nil {
		jsonWriter.InternalServerError("failed to query editors table", err)
		return
	}

	s.redisClient.CacheEditors(channelID, editors)

	response := view.V1GetEditorsResponse{
		Editors: editors,
	}

	jsonWriter.OK(response)
}
