package api

import (
	"net/http"

	"code.justin.tv/cb/hallpass/internal/db"
	"code.justin.tv/cb/hallpass/internal/httputil"
	"code.justin.tv/cb/hallpass/view"
	"goji.io/pat"
)

func (s *Server) getV2Editors(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	channelID := pat.Param(req, "channel_id")

	editors, err := s.dbReader.GetEditorsWithTimestamps(req.Context(), channelID)
	if err != nil {
		jsonWriter.InternalServerError("failed to query editors table", err)
		return
	}

	response := view.V2GetEditorsResponse{
		Editors: convertEditorsToView(editors),
	}

	jsonWriter.OK(response)
}

func convertEditorsToView(editors []db.EditorPermission) []view.Editor {
	editorsView := make([]view.Editor, len(editors))

	for idx, editor := range editors {
		editorsView[idx] = view.Editor{
			EditorUserID: editor.EditorUserID,
			CreatedOn:    editor.CreatedOn,
		}
	}

	return editorsView
}
