package api

import (
	"context"

	"code.justin.tv/cb/hallpass/internal/db"
)

// PermissionsDB contains the basic methods needed for accessing the permissions db.
type PermissionsDB interface {
	GetEditors(ctx context.Context, channelID string) ([]string, error)
	GetEditorsWithTimestamps(ctx context.Context, channelID string) ([]db.EditorPermission, error)
	GetEditableChannels(ctx context.Context, channelID string) ([]string, error)
	CreateEditor(ctx context.Context, channelID string, editorUserID string) error
	DeleteEditor(ctx context.Context, channelID string, editorUserID string) error
	DeleteAllEditors(ctx context.Context, channelID string) error
	DeleteAllEditable(ctx context.Context, channelID string) ([]string, error)
}
