package chatban

import (
	"context"

	"code.justin.tv/cb/hallpass/internal/api"
	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/schema/pkg/chat_ban"
	log "github.com/sirupsen/logrus"
)

type Handler struct {
	DBWriter    api.PermissionsDB
	RedisClient api.PermissionsCache
}

func (h Handler) Handle(ctx context.Context, header *eventbus.Header, event *chat_ban.Create) (err error) {
	bannedUserID := event.BannedUserId
	broadcasterUserID := event.BroadcasterUserId

	err = h.DBWriter.DeleteEditor(ctx, broadcasterUserID, bannedUserID)
	if err != nil {
		log.WithError(err).Error("Failed to delete channel editor from editors table")
		return err
	}

	h.RedisClient.RemoveEditor(broadcasterUserID, bannedUserID)

	log.WithField("bannedUserID", bannedUserID).
		WithField("channelID", broadcasterUserID).
		Infof("Successfully attempted to remove %s as an editor from channel %s due to chat ban.", bannedUserID, broadcasterUserID)

	return nil
}
