package pdms

import (
	"context"

	"code.justin.tv/cb/hallpass/internal/api"
	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/schema/pkg/user"
	log "github.com/sirupsen/logrus"
)

type Handler struct {
	DBWriter    api.PermissionsDB
	RedisClient api.PermissionsCache
	PdmsClient  api.PdmsClient
}

func (h Handler) Handle(ctx context.Context, header *eventbus.Header, event *user.Destroy) (err error) {
	userID := event.UserId

	err = h.DBWriter.DeleteAllEditors(ctx, userID)
	if err != nil {
		log.WithError(err).Error("Failed to delete editors from editors table")

		return err
	}

	// Delete the redis key for the hard deleted user's editors
	h.RedisClient.RemoveAllEditors(userID)

	editable, err := h.DBWriter.DeleteAllEditable(ctx, userID)
	if err != nil {
		log.WithError(err).Error("Failed to delete editables from editors table")

		return err
	}

	// Delete the redis key for what channels the hard deleted user was an editor for
	h.RedisClient.RemoveAllEditable(userID)

	// For each channel where the hard deleted user was an editor, we need to remove the user from its editors key
	for _, channel := range editable {
		h.RedisClient.RemoveEditor(channel, userID)
	}

	err = h.PdmsClient.ReportDeletion(ctx, userID)
	if err != nil {
		log.WithError(err).Error("Failed to send deletion report to pdms")

		return err
	}

	log.Infof("Successfully removed all editors and editable for channel %s", userID)

	return nil
}
