package logging

import (
	"github.com/heroku/rollrus"
	log "github.com/sirupsen/logrus"
)

// SetupRollbar configures logging to rollbar
func SetupRollbar(rollbarTkn, environment string) {
	if rollbarTkn == "" {
		log.Warn("No Rollbar access token found for ", environment)
		log.Warn("Logs will not be sent to Rollbar")
		return
	}

	rollbarLevels := []log.Level{
		log.ErrorLevel,
		log.FatalLevel,
		log.PanicLevel,
		log.WarnLevel,
	}

	rollrus.SetupLoggingForLevels(rollbarTkn, environment, rollbarLevels)
	log.Info("Logs set to send to Rollbar")
}
