#!/bin/bash
set -ex

rm -rf deploy
mkdir -p deploy

cp -R .ebextensions/ deploy/.ebextensions

cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker.pkgs.xarth.tv/cb/hallpass-api:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-hallpass-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

eb deploy cb-hallpass-$ENVIRONMENT-api \
  --label $ENVIRONMENT-api-$GIT_COMMIT \
  --message "$BRANCH" \
  --verbose
