resource "aws_elasticache_cluster" "permissions-cache" {
  cluster_id               = "cb-perm-${var.abbreviated_environment}"
  engine                   = "redis"
  node_type                = "cache.m4.xlarge"
  port                     = 6379
  num_cache_nodes          = 1
  snapshot_retention_limit = 1

  security_group_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  )
  subnet_group_name = aws_elasticache_subnet_group.permissions_elasticache_subnet_group.name
}

resource "aws_elasticache_subnet_group" "permissions_elasticache_subnet_group" {
  name        = "permissions-elasticache-subnet-${var.environment}"
  description = "Redis Subnet group"

  subnet_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.private_subnets,
  )
}
