resource "aws_iam_role" "app" {
  name = "${var.team_code}-${var.name}-${var.environment}"

  assume_role_policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": {
    "Action": "sts:AssumeRole",
    "Effect": "Allow",
    "Principal": {
      "Service": "ec2.amazonaws.com"
    }
  }
}
POLICY
}

data "aws_iam_policy_document" "hallpass-role-policy" {
  policy_id = "hallpass_role_policy"

  # The CloudWatch logs policy allows:
  # - Create groups in CloudWatch logs for proxy and deployment logs
  # - Stream logs from each EC2 instance
  statement {
    actions = [
      "logs:CreateLogStream",
      "logs:PutLogEvents"
    ]

    effect = "Allow"

    resources = [
      "arn:aws:logs:us-west-2:*:*",
      "arn:aws:logs:*:*:log-group:/aws/elasticbeanstalk*"
    ]

    sid = "cloudwatch"
  }

  statement {
    actions = [
      "s3:PutObject",
      "s3:PutObjectACL",
      "s3:GetObject",
      "s3:GetObjectACL",
      "s3:GetBucketACL",
      "s3:ListBucket",
      "s3:DeleteObject"
    ]

    effect = "Allow"

    resources = [
      var.autoprof-bucket,
      "${var.autoprof-bucket}/*"
    ]

    sid = "autoprofs3"
  }
}

resource "aws_iam_role_policy" "hallpass-role-policy" {
  name = "hallpass-service"
  role = aws_iam_role.app.name
  policy = data.aws_iam_policy_document.hallpass-role-policy.json
}

# Instance profile is a container for one single IAM role.
resource "aws_iam_instance_profile" "app" {
  name = aws_iam_role.app.name
  role = aws_iam_role.app.name
}
