resource "aws_db_subnet_group" "hallpass_db_subnet_group" {
  name        = "hallpass-db-subnet-${var.environment}"
  description = "Hallpass DB Subnet group"

  subnet_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.private_subnets,
  )
}

resource "aws_db_instance" "master" {
  engine              = "postgres"
  engine_version      = "9.6.11"
  instance_class      = var.rds_instance_type
  storage_type        = "gp2"
  allocated_storage   = var.rds_storage
  multi_az            = true
  deletion_protection = true

  identifier = "${var.team_code}-${var.name}-${var.environment}"
  name       = var.name
  username   = "master"
  password   = "temporary"

  publicly_accessible = false

  vpc_security_group_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  )

  port                 = 5432
  db_subnet_group_name = aws_db_subnet_group.hallpass_db_subnet_group.name
  monitoring_interval  = 5
  monitoring_role_arn  = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  parameter_group_name = "pg-stat-statements-postgres-9-6"

  backup_retention_period = 1
  backup_window           = "02:00-04:00"

  tags = {
    Environment = var.environment
    Name        = var.name
    Owner       = var.owner
    Project     = var.project
    Team        = var.team
  }

  lifecycle {
    ignore_changes = [engine_version]
  }
}

resource "aws_db_instance" "replica_1" {
  replicate_source_db = aws_db_instance.master.id

  apply_immediately = true

  instance_class    = var.rds_replica_instance_type
  storage_type      = "gp2"
  allocated_storage = var.rds_storage

  identifier          = "${aws_db_instance.master.id}-replica-1"
  name                = aws_db_instance.master.name
  deletion_protection = true

  publicly_accessible = false

  vpc_security_group_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  )

  port                 = aws_db_instance.master.port
  monitoring_interval  = 5
  monitoring_role_arn  = "arn:aws:iam::989470033077:role/rds-monitoring-role"
  parameter_group_name = "pg-stat-statements-postgres-9-6"

  tags = {
    Environment = var.environment
    Name        = var.name
    Owner       = var.owner
    Project     = var.project
    Team        = var.team
  }
}
