resource "aws_route53_zone" "private" {
  name = "${var.abbreviated_environment}.hallpass.twitch.a2z.com"

  vpc {
    vpc_id = data.terraform_remote_state.account.outputs.vpc_id
  }
}

resource "aws_route53_record" "rds_read_replica" {
  zone_id = aws_route53_zone.private.zone_id
  name    = "rds-read-replica"
  type    = "CNAME"
  ttl     = "300"

  weighted_routing_policy {
    weight = 10
  }

  set_identifier = "rds_read_replica_instance"
  records        = [ aws_db_instance.replica_1.address ]
}