variable "account_id" {
  type        = string
  default     = "989470033077"
  description = "AWS account id"
}

variable "autoprof-bucket" {
  type        = string
  description = "Autoprof S3 bucket"
}

variable "asg_max_size" {
  type        = string
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = string
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_profile" {
  type    = string
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "abbreviated_environment" {
  type        = string
  description = "Short environment name so we can fit it into elasticache short name requirements"
}

variable "instance_type" {
  type        = string
  description = "EC2 instance type"
}

variable "name" {
  type        = string
  default     = "hallpass"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "cb/hallpass"
  description = "GitHub repository name"
}

variable "solution_stack_name" {
  type    = string
  default = "64bit Amazon Linux 2018.03 v2.12.14 running Docker 18.03.1-ce"
}

variable "team" {
  type    = string
  default = "Creator Business"
}

variable "team_code" {
  type    = string
  default = "cb"
}

variable "rds_instance_type" {
  type        = string
  description = "instance type of the rds cluster"
}

variable "rds_replica_instance_type" {
  type        = string
  description = "instance type of the rds read replica"
}

variable "rds_storage" {
  type    = string
  default = 1000
}

variable "vpc_endpoint_service_allowed_principals" {
  type        = list(string)
  description = "the arns that are whitelisted to access the VPC endpoint service"
}
