# Alarms when the beanstalk environment health enters Degraded
resource "aws_cloudwatch_metric_alarm" "application_health" {
  alarm_name                = "${var.ebs_name}-application-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20" # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS application"
  insufficient_data_actions = []
  alarm_actions             = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions                = [aws_sns_topic.pagerduty_alerts.arn]
  treat_missing_data        = "notBreaching"

  dimensions = {
    EnvironmentName = var.ebs_name
  }
}

# Alarms when the average latency of the environment crosses 250ms for 20 minutes
resource "aws_cloudwatch_metric_alarm" "app_beanstalk_avg_latency" {
  alarm_name          = "${var.ebs_name}-avg-latency"
  alarm_description   = "Monitors the average latency of ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "ApplicationLatencyP90"
  namespace           = "AWS/ElasticBeanstalk"
  period              = 60
  statistic           = "Average"
  threshold           = 250
  alarm_actions       = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions          = [aws_sns_topic.pagerduty_alerts.arn]
  treat_missing_data  = "notBreaching"

  dimensions = {
    EnvironmentName = var.ebs_name
  }
}

# Alarms when the average cpu utilization of the autoscaling group crosses 80% for 20 minutes
resource "aws_cloudwatch_metric_alarm" "asg_cpu" {
  alarm_name          = "${var.ebs_name}-asg-avg-cpu"
  alarm_description   = "Monitors the average cpu utilization of ${var.name} Elastic Beanstalk autoscaling group"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "CPUUtilization"
  namespace           = "AWS/EC2"
  period              = 60
  statistic           = "Average"
  threshold           = 80
  alarm_actions       = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions          = [aws_sns_topic.pagerduty_alerts.arn]
  treat_missing_data  = "notBreaching"

  dimensions = {
    AutoScalingGroupName = var.asg_name
  }
}

# Alarms when the latency of the ELB to instances is greater than 250ms for 20 minutes
resource "aws_cloudwatch_metric_alarm" "elb_latency" {
  alarm_name          = "${var.ebs_name}-latency"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "Latency"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Average"
  threshold           = 250
  alarm_actions       = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions          = [aws_sns_topic.pagerduty_alerts.arn]

  dimensions = {
    LoadBalancerName = var.elb_name
  }
}

# Alarms when the surge length of the instances in ELB is greater than 1024 for 5 minutes
resource "aws_cloudwatch_metric_alarm" "elb_surgeLength" {
  alarm_name          = "${var.ebs_name}-surgeLength"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 5
  metric_name         = "SurgeQueueLength"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Maximum"
  threshold           = 1024
  alarm_actions       = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions          = [aws_sns_topic.pagerduty_alerts.arn]
  tags                = {severity = var.severity}

  dimensions = {
    LoadBalancerName = var.elb_name
  }
}
