# Alarms when the rds cpu crosses 80% for 20 minutes
resource "aws_cloudwatch_metric_alarm" "db_avg_cpu" {
  alarm_name          = "${var.team_code}-${var.name}-${var.environment}-db-cpu"
  alarm_description   = "Monitors the average CPU of the ${var.name} postgres db"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "CPUUtilization"
  namespace           = "AWS/RDS"
  period              = 60
  statistic           = "Average"
  threshold           = 80
  alarm_actions       = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions          = [aws_sns_topic.pagerduty_alerts.arn]
  treat_missing_data  = "notBreaching"

  dimensions = {
    DBInstanceIdentifier = "${var.team_code}-${var.name}-${var.environment}"
  }
}

# Alarms when the rds db connections exceed 500 for 5 minutes
resource "aws_cloudwatch_metric_alarm" "db_avg_conns" {
  alarm_name          = "${var.team_code}-${var.name}-${var.environment}-db-conns"
  alarm_description   = "Monitors the average db connections of the ${var.name} postgres db"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 5
  metric_name         = "DatabaseConnections"
  namespace           = "AWS/RDS"
  period              = 60
  statistic           = "Average"
  threshold           = 500
  alarm_actions       = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions          = [aws_sns_topic.pagerduty_alerts.arn]
  treat_missing_data  = "notBreaching"

  dimensions = {
    DBInstanceIdentifier = "${var.team_code}-${var.name}-${var.environment}"
  }
}

# Alarms when the rds db storage space drops below 50,000 MB after 5 minutes
resource "aws_cloudwatch_metric_alarm" "db_free_storage_space" {
  alarm_name          = "${var.team_code}-${var.name}-${var.environment}-db-free-space"
  alarm_description   = "Monitors the remaining storage space of the ${var.name} postgres db"
  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = 5
  metric_name         = "FreeStorageSpace"
  namespace           = "AWS/RDS"
  period              = 60
  statistic           = "Average"
  threshold           = 50000
  alarm_actions       = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions          = [aws_sns_topic.pagerduty_alerts.arn]
  treat_missing_data  = "notBreaching"

  dimensions = {
    DBInstanceIdentifier = "${var.team_code}-${var.name}-${var.environment}"
  }
}
