variable "aws_profile" {
  type    = string
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "hallpass"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "team_code" {
  type    = string
  default = "cb"
}

variable "pagerduty_alert_url" {
  type        = string
  description = "pagerduty endpoint to POST to when an alarm is triggered in EBS"
}

variable "ebs_name" {
  type        = string
  description = "EBS name for EBS alarms"
}

variable "elb_name" {
  type        = string
  description = "ELB name for ELB alarms"
}

variable "asg_name" {
  type        = string
  description = "ASG name for ASG alarms"
}

variable "severity" {
  type        = string
  description = "(optional) The severity of the alarm. Either of the following is supported: Low, Medium, High, Critical"
  default     = "Low"
}