variable "account" {
  type        = string
  default     = "989470033077"
  description = "AWS account id"
}

variable "aws_profile" {
  type    = string
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "sqs_queue_name" {
  type        = string
  description = "Name of the SQS queue, e.g. 'cb-hallpass-staging-eventbus-user-destroy', etc."
}

variable "pdms_caller_role_arn" {
  type = string
  description = "The ARN of the role that's assumed in order to call the PDMS API."
}

variable "pdms_lambda_arn" {
    type = string
    description = "The ARN of the PDMS lambda, which is invoked to send responses about user deletion to PDMS."
}

variable "db_host" {
    type = string
    description = "The host address of the hallpass primary database."
}

variable "db_port" {
    type = string
    description = "The port of the hallpass primary database."
}

variable "db_name" {
    type = string
    description = "The table name used to store editors."
}

variable "db_user" {
    type = string
    description = "The user used to login to the hallpass database."
}

variable "db_sslmode" {
    type = string
    description = "The SSL mode used to connect to the hallpass database."
}

variable "db_password_key" {
    type = string
    description = "The key used to lookup the db password from the secret."
}

variable "db_password_secret" {
    type = string
    description = "The key used to lookup the db password from the secret."
}

variable "redis_host" {
    type = string
    description = "The host address of the redis instance used by hallpass."
}

variable "service_name" {
  type        = string
  default     = "hallpass"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "cb/hallpass"
  description = "GitHub repository name"
}

variable "team" {
  type    = string
  default = "Creator Business"
}

variable "team_code" {
  type    = string
  default = "cb"
}

locals {
  sqs_lambda_handler_name = "${var.sqs_queue_name}-handler"
}