terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "cb-hallpass-terraform"
    key     = "production/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

data "aws_caller_identity" "current" {}

module "autoprof" {
  source        = "../modules/autoprof"
  app_name      = "hallpass-production"
  aws_region    = "us-west-2"
  account_id    = data.aws_caller_identity.current.account_id
}

module "app" {
  source = "../modules/hallpass"

  autoprof-bucket         = module.autoprof.autoprof-bucket-arn

  environment             = "production"
  abbreviated_environment = "prd"

  instance_type             = "c5n.4xlarge"
  asg_max_size              = 35
  asg_min_size              = 12
  rds_instance_type         = "db.m5.2xlarge"
  rds_replica_instance_type = "db.m5.4xlarge"

  vpc_endpoint_service_allowed_principals = [
    "arn:aws:iam::047062552417:root",
    "arn:aws:iam::248953866850:root",
    "arn:aws:iam::153570226312:root",
    "arn:aws:iam::162540994885:root",
    "arn:aws:iam::370045434636:root",
    "arn:aws:iam::492198805294:root",
    "arn:aws:iam::222817909900:root",
    "arn:aws:iam::246232734983:root",
    "arn:aws:iam::569753543839:root",
    "arn:aws:iam::524336105177:root", # StreamSchedule-us-west-2
    "arn:aws:iam::981671725203:root", # twitch-nexus
    "arn:aws:iam::931896176507:root", # twitch-users-service-prod
    "arn:aws:iam::608409629292:root", # TwitchExtensionsBarbrady-prod
    "arn:aws:iam::958761666246:root", # twitch-percy-aws-prod (bits)
    "arn:aws:iam::613838774744:root", # Siosa Fulton Port
    "arn:aws:iam::193757392363:root", # GTA service
    "arn:aws:iam::943628345903:root", # twitch-momentum-aws
    "arn:aws:iam::948329120781:root", # twitch-clips-aws
    "arn:aws:iam::746361076297:root", # twitch-cartman-aws
    "arn:aws:iam::823507317004:root", # twitch-gala-aws
    "arn:aws:iam::635065150292:root", # granddads
    "arn:aws:iam::177642657845:root", # twitch-playlists-aws
    "arn:aws:iam::777516492425:root", # twitch-engagement-aws (flipper)
    "arn:aws:iam::947153321414:root", # TwitchRaids-us-west-2
    "arn:aws:iam::028439334451:root", # twitch-api-prod
    "arn:aws:iam::603200399373:root", # twitch-chat-aws
    "arn:aws:iam::747197855261:root", # twitch-reminder
    "arn:aws:iam::358695107714:root", # twitch-sunblast-prod
    "arn:aws:iam::424508469251:root", # twitch-rarecandy-prod
    "arn:aws:iam::556429543300:root", # twitch-connections-aws
    "arn:aws:iam::557220232163:root", # twitch-friendship-prod
    "arn:aws:iam::327710237716:root", # twitch-vax-deathstar-prod-us-west-2
    "arn:aws:iam::884753733696:root", # twitch-highlighter-prod
    "arn:aws:iam::272934794774:root", # twitch-creator-cards+prod-us-west-2
    "arn:aws:iam::427251495892:root", # twitch-creator-personalization+prod-us-west-2
    "arn:aws:iam::916526529404:root", # creator-supers+goals-prod-us-west-2 (TwitchCreatorGoals)
    "arn:aws:iam::964932369655:root", # twitch-box-office-aws
    "arn:aws:iam::433397531694:root", # twich-ads-aws (Saul, Siosa)
    "arn:aws:iam::447680546588:root", # twich-ce-host-aws
    "arn:aws:iam::134912696936:root", # twich-vinyl-aws
    "arn:aws:iam::522398581884:root", # twich-subs-aws
    "arn:aws:iam::787149559823:root", # twitch-graphql-production
    "arn:aws:iam::849839200145:root", # twitch-toolkit-production
    "arn:aws:iam::400960425834:root", # tarkin-prod
    "arn:aws:iam::914569885343:root", # twitch-feed-aws
    "arn:aws:iam::324638692870:root", # twitch-sauron-api-lambda-prod
    "arn:aws:iam::045860054021:root", # twitch-creator-tools+VODCopyrightChecker-prod
    "arn:aws:iam::358399464048:root", # TwitchExpressionsFuji-prod
  ]
}

module "pagerduty_production" {
  source = "../modules/pagerduty"

  environment         = "production"
  pagerduty_alert_url = "https://events.pagerduty.com/integration/3679e8b731df4ec7aff93279f8de9694/enqueue"
  ebs_name            = module.app.ebs_name
  elb_name            = module.app.elb_name
  asg_name            = module.app.asg_name
}

module "pdms_lambda" {
  source = "../modules/pdms_lambda"

  environment          = "production"
  sqs_queue_name       = "cb-hallpass-production-eventbus-user-destroy"
  pdms_caller_role_arn = "arn:aws:iam::125704643346:role/PDMSLambda-CallerRole-13IIND444YKVR"
  pdms_lambda_arn      = "arn:aws:lambda:us-west-2:125704643346:function:PDMSLambda-LambdaFunction-11LXHJVSNJJPY:live"
  db_host              = "cb-hallpass-production.cqyyxr1hxrhn.us-west-2.rds.amazonaws.com"
  db_port              = "5432"
  db_name              = "hallpass"
  db_user              = "master"
  db_sslmode           = "disable"
  db_password_key      = "password"
  db_password_secret   = "hallpass/production/db_password"
  redis_host           = "cb-perm-prd.9jn8pu.0001.usw2.cache.amazonaws.com:6379"
}
