terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "cb-hallpass-terraform"
    key     = "staging/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

data "aws_caller_identity" "current" {}

module "autoprof" {
  source        = "../modules/autoprof"
  app_name      = "hallpass-staging"
  aws_region    = "us-west-2"
  account_id    = data.aws_caller_identity.current.account_id
}

module "app" {
  source = "../modules/hallpass"

  autoprof-bucket         = module.autoprof.autoprof-bucket-arn

  environment             = "staging"
  abbreviated_environment = "stg"

  instance_type             = "c4.large"
  asg_max_size              = 4
  asg_min_size              = 2
  rds_instance_type         = "db.m5.large"
  rds_replica_instance_type = "db.m5.xlarge"

  vpc_endpoint_service_allowed_principals = [
    "arn:aws:iam::047062552417:root",
    "arn:aws:iam::248953866850:root",
    "arn:aws:iam::153570226312:root",
    "arn:aws:iam::162540994885:root",
    "arn:aws:iam::370045434636:root",
    "arn:aws:iam::492198805294:root",
    "arn:aws:iam::222817909900:root",
    "arn:aws:iam::720603942490:root",
    "arn:aws:iam::485349352143:root",
    "arn:aws:iam::154833292779:root", # StreamSchedule-beta-us-west-2
    "arn:aws:iam::517750855377:root", # twitch-nexus-beta
    "arn:aws:iam::404788901388:root", # twitch-users-service-dev
    "arn:aws:iam::020406377953:root", # TwitchExtensionsBarbrady-staging
    "arn:aws:iam::999515204624:root", # twitch-percy-aws-devo (bits)
    "arn:aws:iam::377564515471:root", # Siosa Fulton Port
    "arn:aws:iam::489082260240:root", # GTA service
    "arn:aws:iam::943628345903:root", # twitch-momentum-aws
    "arn:aws:iam::948329120781:root", # twitch-clips-aws
    "arn:aws:iam::316480664867:root", # twitch-cartman-dev
    "arn:aws:iam::823507317004:root", # twitch-gala-aws
    "arn:aws:iam::022085415566:root", # granddads
    "arn:aws:iam::177642657845:root", # twitch-playlists-aws
    "arn:aws:iam::777516492425:root", # twitch-engagement-aws (flipper)
    "arn:aws:iam::841118063981:root", # TwitchRaids-beta-us-west-2
    "arn:aws:iam::327140220177:root", # twitch-api-dev
    "arn:aws:iam::603200399373:root", # twitch-chat-aws
    "arn:aws:iam::589809013211:root", # twitch-reminder+beta
    "arn:aws:iam::334515667361:root", # twitch-sunblast-dev
    "arn:aws:iam::999693245961:root", # twitch-rarecandy-beta
    "arn:aws:iam::740248930772:root", # twitch-connections-dev
    "arn:aws:iam::760419359607:root", # twitch-friendship-dev
    "arn:aws:iam::683605197014:root", # twitch-vax-deathstar-beta-us-west-2
    "arn:aws:iam::003190807961:root", # twitch-highlighter-dev
    "arn:aws:iam::725953065548:root", # twitch-creator-cards+beta-us-west-2
    "arn:aws:iam::760129265807:root", # twitch-creator-personalization+beta-us-west-2
    "arn:aws:iam::679954844189:root", # creator-supers+goals-beta-us-west-2 (TwitchCreatorGoals)
    "arn:aws:iam::664665898521:root", # twitch-box-office-dev
    "arn:aws:iam::433397531694:root", # twich-ads-aws (Saul, Siosa)
    "arn:aws:iam::038504843107:root", # twitch-ce-host-dev
    "arn:aws:iam::134912696936:root", # twich-vinyl-aws
    "arn:aws:iam::522398581884:root", # twich-subs-aws (Valhalla prod)
    "arn:aws:iam::958836777662:root", # twitch-subs-aws (Valhalla dev)
    "arn:aws:iam::645130450452:root", # twitch-graphql-dev
    "arn:aws:iam::144996434858:root", # twitch-toolkit-staging
    "arn:aws:iam::954870414295:root", # tarkin-beta
    "arn:aws:iam::724951484461:root", # twitch-feed-dev
    "arn:aws:iam::042642440985:root", # twitch-sauron-api-lambda-beta
    "arn:aws:iam::875308225711:root", # twitch-creator-tools+VODCopyrightChecker-beta
    "arn:aws:iam::628753431282:root", # TwitchExpressionsFuji-beta
  ]
}

module "pdms_lambda" {
  source = "../modules/pdms_lambda"

  environment          = "staging"
  sqs_queue_name       = "cb-hallpass-staging-eventbus-user-destroy"
  pdms_caller_role_arn = "arn:aws:iam::895799599216:role/PDMSLambda-CallerRole-18451FI19HSXT"
  pdms_lambda_arn      = "arn:aws:lambda:us-west-2:895799599216:function:PDMSLambda-LambdaFunction-IT8I1PE1YR81:live"
  db_host              = "cb-hallpass-staging.cqyyxr1hxrhn.us-west-2.rds.amazonaws.com"
  db_port              = "5432"
  db_name              = "hallpass"
  db_user              = "master"
  db_sslmode           = "disable"
  db_password_key      = "password"
  db_password_secret   = "hallpass/staging/db_password"
  redis_host           = "cb-perm-stg.9jn8pu.0001.usw2.cache.amazonaws.com:6379"
}
