package main

import (
	"code.justin.tv/cb/kinesis_processor/config"
	"code.justin.tv/cb/kinesis_processor/clients"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"time"
	"fmt"
	"os"
	"bufio"
)




func main() {
	conf := config.LoadConfig()
	clients := clients.NewAppClients(conf)

	channelIDs := make(map[int64]bool)

	t1 := time.Now()
	counter := 0
	var exclusiveStartKey map[string]*dynamodb.AttributeValue

	for {
		list,  newExclusiveStartKey, err := clients.Dynamo.FetchMinuteBrodcast(exclusiveStartKey)
		exclusiveStartKey = newExclusiveStartKey

		if err != nil {
			panic(err)
		}
		if exclusiveStartKey == nil {
			break
		}

		for _, item := range *list {
			_, ok := channelIDs[item.ChannelID]
			if !ok {
				channelIDs[item.ChannelID] = true
			}

			counter++
			if counter%10000 == 0 {
				fmt.Println(time.Now() , "] ", counter , " ( ",len(channelIDs) ,") running for ", time.Now().Sub(t1).Seconds(), "s")
				fmt.Println(exclusiveStartKey)
				saveChannelIDs(channelIDs);
				channelIDs = make(map[int64]bool);
			}

		}

	}// read all loop

	saveChannelIDs(channelIDs);
}


func saveChannelIDs(channelIDs map[int64]bool) {
	f, err := os.OpenFile("./channel_ids", os.O_APPEND | os.O_WRONLY | os.O_CREATE, 0600);
	if err != nil {
		panic(err)
	}
	defer f.Close()

	w := bufio.NewWriter(f)
	for key, _ := range channelIDs {
		fmt.Fprintf(w, "%d\n", key)
	}
	w.Flush()

}