package helper

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/ec2rolecreds"
	"github.com/aws/aws-sdk-go/aws/session"
)

// NewAWSCredentials return AWS Credentials object with keys
func NewCredentials(env string, region string) *credentials.Credentials {
	if env == "development" {
		return credentials.NewSharedCredentials("", "twitch-web-dev")
	}

	return ec2rolecreds.NewCredentials(
		session.New(&aws.Config{
			Region: aws.String(region),
		}),
	)
}
