package clients

import (
	_ "github.com/lib/pq"

	"code.justin.tv/cb/kinesis_processor/clients/database"
	"code.justin.tv/cb/kinesis_processor/clients/dynamo_adapter"
	"code.justin.tv/cb/kinesis_processor/clients/kinesis_firehose"
	"code.justin.tv/cb/kinesis_processor/config"
)

// Clients contains the interfaces to all clients.
type Clients struct {
	// Conf initial config
	Conf *config.Config

	// Kinesis firehose client
	Firehose kinesis_firehose.KinesisFirehose
}

// NewAppClients instantiates all clients needed for the application, workerpool, db,
// and cron.
func NewAppClients(conf *config.Config) *Clients {

	return &Clients{
		Conf:     conf,
		Firehose: kinesis_firehose.NewKinesisFirehose(conf, conf.FirehoseS3Bucket, conf.FirehoseS3Prefix),
	}
}

func NewDynamo(conf *config.Config) dynamo_adapter.DynamoAdapter {
	dynamo, err := dynamo_adapter.NewDynamoAdapter(conf)
	if err != nil {
		panic(err)
	}
	return dynamo
}

func newDB(conf *config.Config) database.Database {
	dbDataSource := conf.DBDataSource()
	db, err := database.NewDBConnection("postgres", dbDataSource)
	if err != nil {
		panic(err)
	}

	err = db.CheckDBConnection()
	if err != nil {
		panic(err)
	}
	return db
}
