package database

import (
	"code.justin.tv/cb/kinesis_processor/models"
	log "github.com/sirupsen/logrus"
)

// InsertChannelSession creates a record in 'channel_sessions' table
// given models.ChannelSession and return inserted ID
// or error if anything goes wrong.
func (db *database) InsertChannelSession(model models.ChannelSession) (int64, error) {
	statement := `
		INSERT INTO channel_sessions
			(channel_id, start_time, end_time)
		VALUES($1, $2, $3)
		RETURNING id
	`

	var id int64
	err := db.QueryRow(statement, model.ChannelID, model.StartTime, model.EndTime).Scan(&id)
	if err != nil {
		msg := "Failed to execute InsertChannelSession statement"
		log.WithError(err).Warn(msg)
		return 0, err
	}

	return id, nil
}
