package database

import (
	log "github.com/sirupsen/logrus"
)

// InsertChannelSessionBroadcast creates a record in 'channel_session_broadcasts' table
// given sessionID and array of broadcastIDs []int64
// or error if anything goes wrong.
func (db *database) InsertChannelSessionBroadcasts(sessionID int64, broadcastIDs []int64) error {

	for _, id := range broadcastIDs {
		statement := `
		INSERT INTO channel_session_broadcasts
			(session_id, broadcast_id)
		VALUES($1, $2)
	`

		_, err := db.Exec(statement, sessionID, id)
		if err != nil {
			msg := "Failed to execute InsertChannelSession statement"
			log.WithError(err).Warn(msg)
			return err
		}

	}

	return nil
}
