package database

import (
	"code.justin.tv/cb/kinesis_processor/models"
	"time"
)

// SelectExtandableChannelSession get ChannelSession that time is within 5min
// window, given channelID and time and return models.ChannelSession if found
// or error if anything goes wrong.
func (d *database) SelectExtendableChannelSession(channelID int64, time time.Time) (*models.ChannelSession, error) {
	session := models.ChannelSession{}
	err := d.Get(&session,
		"SELECT * FROM channel_sessions WHERE channel_id = ? AND TIMESTAMPDIFF(MINUTE, end_time, ?) <= 5 ORDER BY id DESC LIMIT 1",
		channelID, time)

	if err != nil {
		return nil, err
	}

	return &session, nil
}
