package database

import (
	"code.justin.tv/cb/kinesis_processor/models"
	"code.justin.tv/cb/kinesis_processor/utils"
	"time"
)

// ExtendChannelSession extends end_time if new end_time is within 5min
// given channelID and endTime and return affected rows count
// or error if anything goes wrong.
func (d *database) ExtendChannelSession(channelID int64, endTime time.Time) (int64, error) {
	//TIMESTAMPDIFF(MINUTE, end_time, :time) > 0 AND
	result, err := d.NamedExec("UPDATE channel_sessions SET end_time = :time WHERE channel_id = :channel_id AND end_time > :time - interval ':session_gap_minutes minutes'",
		map[string]interface{}{
			"time":                endTime.Format(utils.DbTimeFormat),
			"channel_id":          channelID,
			"session_gap_minutes": utils.SessionGapMinutes,
		})
	if err != nil {
		return 0, err
	}

	rows, err := result.RowsAffected()
	if err != nil {
		return 0, err
	}

	return rows, nil
}

// Update update models.ChannelSession in channel_sessions
// using ID and returns error if anything goes wrong.
func (d *database) UpdateChannelSession(model models.ChannelSession) (int64, error) {
	result, err := d.NamedExec("UPDATE channel_sessions SET start_time = :start_time, end_time = :end_time, channel_id = :channel_id WHERE id = :id",
		model,
	)

	if err != nil {
		return 0, err
	}

	rows, err := result.RowsAffected()
	if err != nil {
		return 0, err
	}

	return rows, nil
}
