package dynamo_adapter

import (
	"code.justin.tv/cb/kinesis_processor/models"
	"code.justin.tv/cb/kinesis_processor/utils"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"strconv"
)

func (d *dynamoAdapter) AddChannelSession(obj models.ChannelSession) error {
	item := map[string]*dynamodb.AttributeValue{
		"ChannelID": &dynamodb.AttributeValue{N: aws.String(strconv.FormatInt(obj.ChannelID, 10))},
		"StartTime": &dynamodb.AttributeValue{S: aws.String(obj.StartTime.Format(utils.DbTimeFormat))},
		"EndTime":   &dynamodb.AttributeValue{S: aws.String(obj.EndTime.Format(utils.DbTimeFormat))},
	}

	if len(obj.BroadcastIDs) > 0 {
		item["BroadcastIDs"] = &dynamodb.AttributeValue{NS: utils.AwsArrayFromInt64List(obj.BroadcastIDs)}
	}

	_, err := d.client.PutItem(&dynamodb.PutItemInput{
		Item:      item,
		TableName: aws.String(TableChannelSessions),
	})

	return err
}
