package sqs_messenger

import (
	"time"

	"github.com/aws/aws-sdk-go/service/sqs"
)

// Message is container of generic message with aciton and attributes
type Message struct {
	Type       string       `json:"Type"`
	MessageID  string       `json:"MessageId"`
	TopicArn   string       `json:"TopicArn"`
	Subject    string       `json:"Subject"`
	Message    string       `json:"Message"`
	Timestamp  time.Time    `json:"Timestamp"`
	SqsMessage *sqs.Message `json:"-"`
}

/*

{
  "Type" : "Notification",
  "MessageId" : "eb6c765b-6883-5564-b7ca-27b05a537576",
  "TopicArn" : "arn:aws:sns:us-west-2:848744099708:TwitchStreamReadyNotifications",
  "Subject" : "StreamReady",
  "Message" : "{\"channel_id\":86313367,\"channel\":\"nsg_locke\",\"stream_id\":25805283600,\"session_id\":\"088bb7b5-9877-474b-903c-85dee35b54a5\",\"broadcast_tag\":\"broadcaster=unknown_rtmp\"}",
  "Timestamp" : "2017-07-20T22:37:04.890Z",
  "SignatureVersion" : "1",
  "Signature" : "LsqOTCsrzqRlgwT6yDIC4pLe91Trd6U5I0q2ND9g3dRW6K8AMTSDKLPZsqcAB8PZGkmQ+K8uUlEwq1WjjkRcaCSzgy/dJsgE/hEd78+UuTQ9i4A2tf2KlKHWk/BN4RxCoqmbwzP3pQEipcLbtWCHc593lBEjh0G7197opeC/P+RdznuOyspST2qqsW39H26XudIWRqmMCaUWrbyIwhz+5C+M9v0zuDqz4MkLAxTDa+tABGWyvygbcaQoasfGVNdk/vmzK0pIG0C9v5OGlGcBdHhCFW9W88lGaXBltwokp3u/Z2s9mxucAYJwJ7+0EApnGvgqFuKfUvnzGiadLu2ThQ==",
  "SigningCertURL" : "https://sns.us-west-2.amazonaws.com/SimpleNotificationService-b95095beb82e8f6a046b3aafc7f4149a.pem",
  "UnsubscribeURL" : "https://sns.us-west-2.amazonaws.com/?Action=Unsubscribe&SubscriptionArn=arn:aws:sns:us-west-2:848744099708:TwitchStreamReadyNotifications:6ab366fe-f1c0-4a9f-af32-9d4471b36c43"
}

*/
