import javaposse.jobdsl.dsl.helpers.*
import javaposse.jobdsl.dsl.helpers.step.*

freeStyleJob('cb-kinesis-processor') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'cb/kinesis_processor', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -v -f build.json'
    saveDeployArtifact 'cb/kinesis_processor', '.manta'
  }
}

def projects = [
  dev: [
    branch: '${GIT_COMMIT}',
    keyId: 'aws-web-dev-access-key',
    secretId: 'aws-web-dev-secret-key',
    s3Bucket: 'twitch-web-dev'
  ],
  prod: [
    branch: 'origin/master',
    keyId: 'aws-web-prod-access-key',
    secretId: 'aws-web-prod-secret-key',
    s3Bucket: 'twitch-web-aws'
  ]
]

projects.each { environment, spec ->
  job {
    name "cb-kinesis-processor-deploy-${environment}"
    using "TEMPLATE-deploy"

    scm {
      git {
        remote {
          github 'cb/kinesis_processor', 'ssh', 'git-aws.internal.justin.tv'
          credentials 'git-aws-read-key'
          if (spec['branch'] != null) {
            branch spec['branch']
          }
        }
        clean true
      }
    }

    wrappers {
      credentialsBinding {
        string 'AWS_ACCESS_KEY', spec['keyId']
        string 'AWS_SECRET_KEY', spec['secretId']
      }
    }

    steps {
      app = "cb-kinesis-processor"
      filename = "app.zip"
      app_version = "\$GIT_COMMIT-\$JOB_NAME-\$BUILD_NUMBER"

      ebconfig = """global:
       |  application_name: ${app}
       |  default_region: us-west-2
       |option_settings:
       | - namespace: aws:elasticbeanstalk:command
       |   option_name: Timeout
       |   value: 1800""".stripMargin()

      shell """apt-get install -y zip
        |zip -r ${filename} .
        """.stripMargin()

      shell """\
        set +x
        export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
        export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
        set -x
        export AWS_DEFAULT_REGION=us-west-2
        aws s3 cp ${filename} s3://${spec['s3Bucket']}/apps/${app}/\$GIT_COMMIT.zip
        aws elasticbeanstalk create-application-version --no-auto-create-application --application-name ${app} --version-label ${app_version} --source-bundle S3Bucket=${spec['s3Bucket']},S3Key=apps/${app}/\$GIT_COMMIT.zip
        mkdir -p .elasticbeanstalk
        cat > .elasticbeanstalk/config.yml <<EOF
        ${ebconfig}
        EOF
        eb deploy ${app}-misc-\$ENVIRONMENT --version ${app_version} | tee ./${app}.out
        eb deploy ${app}-vp-\$ENVIRONMENT --version ${app_version} | tee -a ./${app}.out
        if [ $(cat ./${app}.out | grep "Environment update completed successfully" | wc -l) -ge "2" ]; then true; else false; fi;
        rm -f ./${app}.out  
      """.stripIndent()
    }
  }
}
